function [Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,E_bot,E_top] = ...
    fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,delta,delta_c,D_center,~,...
    eps_reg,eta_reg,flag_cheb,flag_fric,~,flag_plot_cap,flag_plot_diag,~,flag_reg,...
    flag_seismic,g,kappa,K_eff,G,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
    sigma_v_0,theta,T,U,y_bot,y_delta,y_plot_max_delta,y_plot_min_delta,y_tilde,z_j)
%
% Computes the largest eigenvalues for bottom and top patches with the aid of Chebyshev
% polynomials, without taking into account coupling effects between the two slip patches. 
%

% Compute auxiliary variables:
A = G / (2*pi*(1-nu));
N = cheb_terms; % number of terms in Chebyshev expansion (note: one element less than in paper)  
n_0 = [0,0,1./(2*(3:N))];
N_0 = diag(n_0);
n_2 = [0,0,1./(2*(1:N-2))]; % n_tilde
N_2 = diag(n_2); % N_tilde
U_1 = [zeros(N,1),U(:,1:N-1)];
U_2 = [zeros(N,2),U(:,1:N-2)]; % U_tilde
T(:,1) = T(:,1)/2; % to account for halving of first coefficient 

% % % Recover grid info (see fault_slip_delta.m for definitions):
% % n_y_bot = (length(y_delta)-2)/2;
% % n_y_top = n_y_bot;
% % 
% % y_bot = y_delta(2:n_y_bot+1);
% % y_top = y_delta(n_y_bot+2:end-1);
% % 
% % delta_bot = delta(2:n_y_bot+1);
% % delta_top = delta(n_y_bot+2:end-1);

% Recover grid info (see fault_slip_delta.m for definitions):
n_y_bot = length(y_bot);
n_y_top = length(y_delta) - n_y_bot - 2;

y_top = y_delta(n_y_bot+2:end-1);

delta_bot = delta(2:n_y_bot+1);
delta_top = delta(n_y_bot+2:end-1);

% Compute critical slip length for bottom patch:
% Approximate analytical solution (Uenishi and Rice):
[~,~,~,~,~,~,~,~,~,~,sigma_norm_eff_comb,~,~,~,~,~,~,~,~] = ...
    fault_slip_sigma(a,alpha,b,delta_bot,delta_c,D_center,eps_reg,eta_reg,flag_fric,...
    flag_reg,g,kappa,K_eff,mu_dyn,mu_st,n_y_bot,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
    sigma_v_0,theta,y_bot,y_bot,y_bot);
w_bar = ( trapz(y_bot,-sigma_norm_eff_comb.* (abs(delta_bot) <= delta_c) ) * ...
    (mu_st-mu_dyn) / delta_c ) / (y_tilde(2)-y_tilde(1));
Delta_y_UR_bot = 1.158*G/(w_bar*(1-nu));

% Semi-analytical solution in terms of Chebyshev polynomials:
if flag_cheb == 0
    Delta_y = y_tilde(2)-y_tilde(1);
    y_barbar = (y_tilde(1)+y_tilde(2))/2;
    y_j = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points; y_minus < y_j < y_plus
    sigma_j = interp1(y_bot,sigma_norm_eff_comb,y_j,'pchip'); % 1 x N vector of combined ...
    % effective normal stresses
    delta_j = interp1(y_bot,delta_bot,y_j,'pchip'); % 1 x N vector of fault slip
else
    sigma_j = sigma_norm_eff_comb; 
    delta_j = delta_bot;
end
ww = -sigma_j .* (mu_st - mu_dyn) .* (abs(delta_j) <= delta_c) ./ (delta_c);
    % 1 x N vector
W = diag(ww); % N x N diagonal matrix
zz = sqrt(1-z_j.^2)/(pi*A); % 1 x N vector
Z = diag(zz); % N x N diagonal matrix
% a_tilde = -( (acos(z_j) - pi - z_j.*sqrt(1-z_j.^2))/(2*pi*A) )'; % N x 1 vector  
% AA_tilde = [zeros(N,1),a_tilde,zeros(N,N-2)]; 
% AA = W*(AA_tilde + Z*(U*N_0-U_2*N_2) );
AA = W*Z*(U*N_0-U_2*N_2);
BB = 2*T;
% % % [E_bot,e_bot] = eigs(AA,BB,1);
% % % (AA*E_bot - e_bot*BB*E_bot)' * (AA*E_bot - e_bot*BB*E_bot) % check; should be zero
AA_bar = AA(2:N-1,3:N);
BB_bar = BB(2:N-1,3:N);
[E_bar_bot,e_bar_bot] = eigs(AA_bar,BB_bar,1);
e_bot = e_bar_bot;
E_bot = [0;0;E_bar_bot];

% Compute critical slip length for top patch:
% Approximate analytical solution (Uenishi and Rice):
[~,~,~,~,~,~,~,~,~,~,sigma_norm_eff_comb,~,~,~,~,~,~,~,~] = ...
    fault_slip_sigma(a,alpha,b,delta_top,delta_c,D_center,eps_reg,eta_reg,flag_fric,...
    flag_reg,g,kappa,K_eff,mu_dyn,mu_st,n_y_top,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
    sigma_v_0,theta,y_top,y_top,y_top);
% % %   w_bar = (trapz(y_top,sigma_norm_eff_comb) * (mu_st-mu_dyn) / delta_c ) / ...
% % %   (y_tilde(4)-y_tilde(3)); % continuously descending weakening branch
w_bar = (trapz(y_top,-sigma_norm_eff_comb.* (abs(delta_top) <= delta_c) ) * ...
    (mu_st-mu_dyn) / delta_c ) / (y_tilde(4)-y_tilde(3));
% % w_bar = -sigma_norm_eff_comb(1)* (mu_st-mu_dyn) / delta_c;
Delta_y_UR_top = 1.158*G/(w_bar*(1-nu));

% Semi-analytical solution in terms of Chebyshev polynomials:
Delta_y = y_tilde(4)-y_tilde(3);
y_barbar = (y_tilde(3)+y_tilde(4))/2;
y_j = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points; y_minus < y_j < y_plus
if flag_cheb == 0
    sigma_j = interp1(y_top,sigma_norm_eff_comb,y_j,'pchip'); % 1 x N vector of combined ...
    %   effective normal stresses
    delta_j = interp1(y_top,delta_top,y_j,'pchip'); % 1 x N vector of fault slip
else
    sigma_j = sigma_norm_eff_comb;
    delta_j = delta_top;
end
% % % ww = -sigma_j .* (mu_st - mu_dyn) ./ (2*pi*A*delta_c); % 1 x N variable coefficient vector; ...
% % %      % continuously descending weakening branch
ww = -sigma_j .* (mu_st - mu_dyn) .* (abs(delta_j) <= delta_c) ./ delta_c; ...
    % 1 x N vector
W = diag(ww); % N x N diagonal matrix
zz = sqrt(1-z_j.^2)/(pi*A); % 1 x N vector
Z = diag(zz); % N x N diagonal matrix
% a_tilde = -( (acos(z_j) - z_j.*sqrt(1-z_j.^2))/(2*pi*A) )'; % N x 1 vector  
% AA_tilde = [zeros(N,1),a_tilde,zeros(N,N-2)]; 
% AA = W*( AA_tilde + Z*(U*N_0-U_2*N_2) );
AA = W*Z*(U*N_0-U_2*N_2);
BB = 2*T;
% [E_top,e_top] = eigs(AA,BB,1); % regular eigenproblem (without constraints on c_0 and c_1)
% % % (AA*E_top - e_top*BB*E_top)' * (AA*E_top - e_top*BB*E_top) % check; should be zero
AA_bar = AA(2:N-1,3:N);
BB_bar = BB(2:N-1,3:N);
[E_bar_top,e_bar_top] = eigs(AA_bar,BB_bar,1); % eigenpr. with constr. on c_0 and c_1
e_top = e_bar_top;
E_top = [0;0;E_bar_top];
% % % (AA_bar*E_bar_top - e_bar_top*BB_bar*E_bar_top)' * ...
% % %     (AA_bar*E_bar_top - e_bar_top*BB_bar*E_bar_top) % check; should be zero


% %%%%
% % test code for Bernard:
% a_tilde = ( -acos(z_j)/(pi*A) )'; % N x 1 vector  
% AA_tilde = [a_tilde,zeros(N,N-1)];
% AA = W*( AA_tilde - Z*U_1);
% BB = -2*U_1;
% CC = AA-BB;
% [E_top_B,e_top_B] = eigs(CC,1);
% e_top_B
% ( (CC-e_top_B*eye(N))*E_top_B )' * ( (CC-e_top_B*eye(N))*E_top_B ) % check; should be zero
% %%%%

% w_bar_num = w_bar * ones(1,N) / (2*pi*A);
% W_bar = diag(w_bar_num); % weighted averaged variable-coefficient N x N diagonal matrix
% [E_top,e_top] = eigs(W_bar*Z*(U*N_0-U_2*N_2),T,1);

% Plot diagnostics to check slip-weakening friction computation:  
if flag_plot_diag == 1 && flag_seismic == 1
    fault_slip_plot_diag_eigen(a,A,colors,delta_c,delta_j,delta_top,Delta_y,E_top,...
        flag_plot_cap,mu_dyn,mu_st,N,N_0,N_2,sigma_j,T,U,U_1,U_2,ww,y_j,y_plot_max_delta,...
        y_plot_min_delta,y_tilde,y_top,z_j);    
end

% Write coefficient info to screen (for diagnostics):
% fprintf('\rCoefficient c_0 = %7.2f\r',E_top(1));
% fprintf('Coefficient c_1 = %7.2f\r',E_top(2));
% fprintf('Sum even coefficients / average coefficient value = %7.2f\r',...
%     sum(E_top(1:2:end))/(sum(E_top(1:end))/N));
% fprintf('Sum odd coefficients / average coefficient value = %7.2f\r',...
%     sum(E_top(2:2:end))/(sum(E_top(1:end))/N));
% fprintf('Sum even coefficients / sum total coefficients = %7.2f\r',...
%     sum(E_top(1:2:end))/sum(E_top(1:end)));
% fprintf('Sum odd coefficients / sum total coefficients = %7.2f\r\r',...
%     sum(E_top(2:2:end))/sum(E_top(1:end)));
